using System;

using gov.va.med.vbecs.BOL;
using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.GUI.controls;
using BrRules = gov.va.med.vbecs.Common.VbecsBrokenRules.LabelPrinterConfig;

namespace gov.va.med.vbecs.admin.GUI
{
	/// <summary>
	/// User control encapsulating logic for editing division label printer configuration.
	/// </summary>
	public class EditDivisionLabelPrinterConfig : BaseDivisionBoundControl
	{
		private System.Windows.Forms.GroupBox grpLabelPrinter;
		private System.Windows.Forms.TextBox txtPrinterListenerIPAddress;
		private System.Windows.Forms.Label lblPrinterListenerIPAddress;
		private VbecsNumericUpDown updPrinterListenerTcpPort;
		private System.Windows.Forms.Label lblPrinterListenerTcpPort;
		private VbecsNumericUpDown updLabelPrinterComPort;
		private System.Windows.Forms.Label lblLabelPrinterComPort;
		private System.Windows.Forms.CheckBox cbDivisionUsesLabelPrinter;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.ComponentModel.IContainer components;

		/// <summary>
		/// CR 2320
		/// </summary>
		public gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbReportPrinter;

		/// <summary>
		/// Constructor
		/// </summary>
		public EditDivisionLabelPrinterConfig()
			: base( BrRules.FormClassName )
		{
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();

			GuiUtility.SetNumericUpdownMinMax( updLabelPrinterComPort, LabelPrinterConfig.MinComPortNumber, LabelPrinterConfig.MaxComPortNumber );
			GuiUtility.SetNumericUpdownMinMax( updPrinterListenerTcpPort, LabelPrinterConfig.MinTcpPortNumber, LabelPrinterConfig.MaxTcpPortNumber );

			PopulatePrinterComboBox(); // CR 2320
		}

		/// <summary>
		/// BindValidator
		/// </summary>
		protected override void BindValidator()
		{
			InputValidator.SetControlBindings( txtPrinterListenerIPAddress, BrRules.ListenerIPAddressNotSet );
			InputValidator.SetControlBindings( updPrinterListenerTcpPort, BrRules.ListenerTcpPortNumberNotSet, BrRules.ListenerTcpPortNumberOutOfRange );
			InputValidator.SetControlBindings( updLabelPrinterComPort, BrRules.ComPortNumberNotSet, BrRules.ComPortNumberOutOfRange );
		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			this.grpLabelPrinter = new System.Windows.Forms.GroupBox();
			this.txtPrinterListenerIPAddress = new System.Windows.Forms.TextBox();
			this.lblPrinterListenerIPAddress = new System.Windows.Forms.Label();
			this.updPrinterListenerTcpPort = new VbecsNumericUpDown();
			this.lblPrinterListenerTcpPort = new System.Windows.Forms.Label();
			this.updLabelPrinterComPort = new VbecsNumericUpDown();
			this.lblLabelPrinterComPort = new System.Windows.Forms.Label();
			this.cbDivisionUsesLabelPrinter = new System.Windows.Forms.CheckBox();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.cmbReportPrinter = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.grpLabelPrinter.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.updPrinterListenerTcpPort)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.updLabelPrinterComPort)).BeginInit();
			this.groupBox1.SuspendLayout();
			this.SuspendLayout();
			// 
			// grpLabelPrinter
			// 
			this.grpLabelPrinter.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpLabelPrinter.Controls.Add(this.txtPrinterListenerIPAddress);
			this.grpLabelPrinter.Controls.Add(this.lblPrinterListenerIPAddress);
			this.grpLabelPrinter.Controls.Add(this.updPrinterListenerTcpPort);
			this.grpLabelPrinter.Controls.Add(this.lblPrinterListenerTcpPort);
			this.grpLabelPrinter.Controls.Add(this.updLabelPrinterComPort);
			this.grpLabelPrinter.Controls.Add(this.lblLabelPrinterComPort);
			this.grpLabelPrinter.Location = new System.Drawing.Point(0, 0);
			this.grpLabelPrinter.Name = "grpLabelPrinter";
			this.grpLabelPrinter.Size = new System.Drawing.Size(264, 124);
			this.grpLabelPrinter.TabIndex = 7;
			this.grpLabelPrinter.TabStop = false;
			// 
			// txtPrinterListenerIPAddress
			// 
			this.erpMainProvider.SetIconAlignment(this.txtPrinterListenerIPAddress, System.Windows.Forms.ErrorIconAlignment.MiddleLeft);
			this.txtPrinterListenerIPAddress.Location = new System.Drawing.Point(124, 74);
			this.txtPrinterListenerIPAddress.Name = "txtPrinterListenerIPAddress";
			this.txtPrinterListenerIPAddress.Size = new System.Drawing.Size(96, 20);
			this.txtPrinterListenerIPAddress.TabIndex = 25;
			this.txtPrinterListenerIPAddress.Text = "";
			this.txtPrinterListenerIPAddress.TextChanged += new System.EventHandler(this.DataEntryFields_DataChanged);
			// 
			// lblPrinterListenerIPAddress
			// 
			this.lblPrinterListenerIPAddress.Location = new System.Drawing.Point(8, 74);
			this.lblPrinterListenerIPAddress.Name = "lblPrinterListenerIPAddress";
			this.lblPrinterListenerIPAddress.Size = new System.Drawing.Size(88, 20);
			this.lblPrinterListenerIPAddress.TabIndex = 24;
			this.lblPrinterListenerIPAddress.Text = "IP Address*";
			// 
			// updPrinterListenerTcpPort
			// 
			this.erpMainProvider.SetIconAlignment(this.updPrinterListenerTcpPort, System.Windows.Forms.ErrorIconAlignment.MiddleLeft);
			this.updPrinterListenerTcpPort.Location = new System.Drawing.Point(124, 47);
			this.updPrinterListenerTcpPort.Maximum = new System.Decimal(new int[] {
																					  65535,
																					  0,
																					  0,
																					  0});
			this.updPrinterListenerTcpPort.Name = "updPrinterListenerTcpPort";
			this.updPrinterListenerTcpPort.Size = new System.Drawing.Size(60, 20);
			this.updPrinterListenerTcpPort.TabIndex = 23;
			this.updPrinterListenerTcpPort.Value = new System.Decimal(new int[] {
																					21777,
																					0,
																					0,
																					0});
			this.updPrinterListenerTcpPort.KeyUp += new System.Windows.Forms.KeyEventHandler(this.NumericUpDown_KeyUp);
			this.updPrinterListenerTcpPort.ValueChanged += new System.EventHandler(this.DataEntryFields_DataChanged);
			// 
			// lblPrinterListenerTcpPort
			// 
			this.lblPrinterListenerTcpPort.Location = new System.Drawing.Point(8, 47);
			this.lblPrinterListenerTcpPort.Name = "lblPrinterListenerTcpPort";
			this.lblPrinterListenerTcpPort.Size = new System.Drawing.Size(108, 20);
			this.lblPrinterListenerTcpPort.TabIndex = 22;
			this.lblPrinterListenerTcpPort.Text = "TCP Port Number*";
			// 
			// updLabelPrinterComPort
			// 
			this.erpMainProvider.SetIconAlignment(this.updLabelPrinterComPort, System.Windows.Forms.ErrorIconAlignment.MiddleLeft);
			this.updLabelPrinterComPort.Location = new System.Drawing.Point(124, 20);
			this.updLabelPrinterComPort.Minimum = new System.Decimal(new int[] {
																				   1,
																				   0,
																				   0,
																				   0});
			this.updLabelPrinterComPort.Name = "updLabelPrinterComPort";
			this.updLabelPrinterComPort.Size = new System.Drawing.Size(60, 20);
			this.updLabelPrinterComPort.TabIndex = 0;
			this.updLabelPrinterComPort.Value = new System.Decimal(new int[] {
																				 1,
																				 0,
																				 0,
																				 0});
			this.updLabelPrinterComPort.KeyUp += new System.Windows.Forms.KeyEventHandler(this.NumericUpDown_KeyUp);
			this.updLabelPrinterComPort.ValueChanged += new System.EventHandler(this.DataEntryFields_DataChanged);
			// 
			// lblLabelPrinterComPort
			// 
			this.lblLabelPrinterComPort.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblLabelPrinterComPort.Location = new System.Drawing.Point(8, 20);
			this.lblLabelPrinterComPort.Name = "lblLabelPrinterComPort";
			this.lblLabelPrinterComPort.Size = new System.Drawing.Size(148, 20);
			this.lblLabelPrinterComPort.TabIndex = 21;
			this.lblLabelPrinterComPort.Text = "COM Port Number*";
			this.lblLabelPrinterComPort.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cbDivisionUsesLabelPrinter
			// 
			this.cbDivisionUsesLabelPrinter.Location = new System.Drawing.Point(8, 0);
			this.cbDivisionUsesLabelPrinter.Name = "cbDivisionUsesLabelPrinter";
			this.cbDivisionUsesLabelPrinter.Size = new System.Drawing.Size(160, 16);
			this.cbDivisionUsesLabelPrinter.TabIndex = 26;
			this.cbDivisionUsesLabelPrinter.Text = "Division Uses Label Printer";
			this.cbDivisionUsesLabelPrinter.CheckedChanged += new System.EventHandler(this.cbDivisionUsesLabelPrinter_CheckedChanged);
			// 
			// groupBox1
			// 
			this.groupBox1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.groupBox1.Controls.Add(this.cmbReportPrinter);
			this.groupBox1.Location = new System.Drawing.Point(268, 0);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(192, 124);
			this.groupBox1.TabIndex = 27;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Default Report Printer*";
			// 
			// cmbReportPrinter
			// 
			this.cmbReportPrinter.Interval = 500;
			this.cmbReportPrinter.Location = new System.Drawing.Point(8, 20);
			this.cmbReportPrinter.Name = "cmbReportPrinter";
			this.cmbReportPrinter.Size = new System.Drawing.Size(172, 21);
			this.cmbReportPrinter.TabIndex = 1;
			this.cmbReportPrinter.SelectedIndexChanged += new System.EventHandler(this.DataEntryFields_DataChanged);
			// 
			// EditDivisionLabelPrinterConfig
			// 
			this.Controls.Add(this.groupBox1);
			this.Controls.Add(this.cbDivisionUsesLabelPrinter);
			this.Controls.Add(this.grpLabelPrinter);
			this.Name = "EditDivisionLabelPrinterConfig";
			this.Size = new System.Drawing.Size(464, 124);
			this.grpLabelPrinter.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.updPrinterListenerTcpPort)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.updLabelPrinterComPort)).EndInit();
			this.groupBox1.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

	
		// Populates the printer combo box with all printers installed on the
		// system (CR 2320).
		private void PopulatePrinterComboBox()
		{
			foreach (string printer in Common.Utility.GetPrintersInstalledOnServer())
			{
				cmbReportPrinter.Items.Add(printer);
			}
		}
		
		/// <summary>
		/// DisplayData
		/// </summary>
		protected override void DisplayData()
		{
			if( BoundDivision.UsesLabelPrinter )
				TransferDivisionDataToWidgets();
			else
				ResetWidgetsToDefaultValues();
		}

		/// <summary>
		/// Get BusinessObjectUnderValidation
		/// </summary>
		protected override BaseBusinessObject BusinessObjectUnderValidation
		{
			get
			{
				return BoundDivision.LabelPrinterConfig;
			}
		}

		/// <summary>
		/// TransferUserInputToBoundDivisionObject
		/// </summary>
		protected override void TransferUserInputToBoundDivisionObject()
		{
			// CR 2320
			BoundDivision.PrinterName = (string) this.cmbReportPrinter.SelectedItem;
			
			BoundDivision.UsesLabelPrinter = cbDivisionUsesLabelPrinter.Checked;

			if( !BoundDivision.UsesLabelPrinter )
			{				
				BoundDivision.LabelPrinterConfig = null;
				return;
			}

			if( BoundDivision.LabelPrinterConfig == null )
				BoundDivision.LabelPrinterConfig = new LabelPrinterConfig();
		
			BoundDivision.UsesLabelPrinter = cbDivisionUsesLabelPrinter.Checked;

            try
            {   //CR3321 - updated to use VbecsNumericUpDown which throws a FormatException on .Get() if bad data
                BoundDivision.LabelPrinterConfig.ComPortNumber = StUiNullConvert.DecimalToInt32(updLabelPrinterComPort.Value);
            }
            catch (FormatException)
            {
                BoundDivision.IsDirty = true;
            }

            try
            {   //CR3321 - updated to use VbecsNumericUpDown which throws a FormatException on .Get() if bad data
                BoundDivision.LabelPrinterConfig.ListenerTcpPortNumber = StUiNullConvert.DecimalToInt32(updPrinterListenerTcpPort.Value);
            }
            catch (FormatException)
            {
                BoundDivision.IsDirty = true;
            }
		    BoundDivision.LabelPrinterConfig.ListenerIPAddress = InputValidator.VerifyIPAddress( txtPrinterListenerIPAddress, false ) ? StUiNullConvert.ToIPAddress( txtPrinterListenerIPAddress.Text ) : null;
		}

		private void TransferDivisionDataToWidgets()
		{
			cbDivisionUsesLabelPrinter.Checked = grpLabelPrinter.Enabled = BoundDivision.UsesLabelPrinter;
			cbDivisionUsesLabelPrinter.Enabled = true;

			updLabelPrinterComPort.Value = StUiNullConvert.DecimalFrom( BoundDivision.LabelPrinterConfig.ComPortNumber, LabelPrinterConfig.DefaultComPortNumber );
			updPrinterListenerTcpPort.Value = StUiNullConvert.DecimalFrom( BoundDivision.LabelPrinterConfig.ListenerTcpPortNumber, LabelPrinterConfig.DefaultTcpPortNumber );
			txtPrinterListenerIPAddress.Text = StUiNullConvert.From( BoundDivision.LabelPrinterConfig.ListenerIPAddress );
		}

		private void ResetWidgetsToDefaultValues()
		{
			InputValidator.ClearValidationErrorsForAllBoundControls();

			// CR 2320
			cbDivisionUsesLabelPrinter.Enabled = true;
			cbDivisionUsesLabelPrinter.Checked = grpLabelPrinter.Enabled = false;
			
			cmbReportPrinter.Enabled = true;
			cmbReportPrinter.SelectedItem = null;
			
			updLabelPrinterComPort.Value = LabelPrinterConfig.DefaultComPortNumber;
			updPrinterListenerTcpPort.Value = LabelPrinterConfig.DefaultTcpPortNumber;
			txtPrinterListenerIPAddress.Text = String.Empty;
		}

		private void cbDivisionUsesLabelPrinter_CheckedChanged(object sender, System.EventArgs e)
		{
			if( DataLoadMode.IsLocked )
				return;

			grpLabelPrinter.Enabled = cbDivisionUsesLabelPrinter.Checked;

			DataEntryFields_DataChanged( sender, e );
		}

		/// <summary>
		/// ResetUiToNoSelection
		/// </summary>
		protected override void ResetUiToNoSelection()
		{
			DataLoadMode.Lock();

			ResetWidgetsToDefaultValues();

			DataLoadMode.Release();
			
			grpLabelPrinter.Enabled = cbDivisionUsesLabelPrinter.Enabled = false;

			// CR 2320
			this.cmbReportPrinter.Enabled = false;
		}
	}
}
